<?php
/*
Plugin Name: Elfsight File Embed CC
Description: Embed any file into your web pages to enable viewing and downloading.
Plugin URI: https://elfsight.com/file-embed-widget/codecanyon/?utm_source=markets&utm_medium=codecanyon&utm_campaign=file-embed&utm_content=plugin-site
Version: 1.1.1
Author: Elfsight
Author URI: https://elfsight.com/?utm_source=markets&utm_medium=codecanyon&utm_campaign=file-embed&utm_content=plugins-list
*/

if (!defined('ABSPATH')) exit;


require_once('core/elfsight-plugin.php');

$elfsight_file_embed_config_path = plugin_dir_path(__FILE__) . 'config.json';
$elfsight_file_embed_config = json_decode(file_get_contents($elfsight_file_embed_config_path), true);

new ElfsightFileEmbedPlugin(
    array(
        'name' => esc_html__('File Embed'),
        'description' => esc_html__('Embed any file into your web pages to enable viewing and downloading.'),
        'slug' => 'elfsight-file-embed',
        'version' => '1.1.1',
        'text_domain' => 'elfsight-file-embed',
        'editor_settings' => $elfsight_file_embed_config['settings'],
        'editor_preferences' => $elfsight_file_embed_config['preferences'],

        'plugin_name' => esc_html__('Elfsight File Embed'),
        'plugin_file' => __FILE__,
        'plugin_slug' => plugin_basename(__FILE__),

        'vc_icon' => plugins_url('assets/img/vc-icon.png', __FILE__),
        'menu_icon' => plugins_url('assets/img/menu-icon.svg', __FILE__),

        'update_url' => esc_url('https://a.elfsight.com/updates/v1/'),
        'product_url' => esc_url('https://codecanyon.net/item/file-viewer-wordpress-file-embed-plugin/24013780?ref=Elfsight'),
        'helpscout_plugin_id' => 110708
    )
);

?>
